/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXLIFFHandler;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.VWConfigAppSpaceNode;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigCommittalDialog;
import filenet.vw.toolkit.admin.VWConfigEventLogNode;
import filenet.vw.toolkit.admin.VWConfigFolderNode;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRosterNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.export.VWExportWizardDialog;
import filenet.vw.toolkit.admin.export.VWImportDialog;
import filenet.vw.toolkit.admin.property.appspace.VWAppSpacePropertyDialog;
import filenet.vw.toolkit.admin.property.appspace.VWNewAppSpaceDialog;
import filenet.vw.toolkit.admin.property.integrator.VWComponentPropertyDialog;
import filenet.vw.toolkit.admin.property.integrator.VWComponentRegistrationDialog;
import filenet.vw.toolkit.admin.property.integrator.VWNewComponentDialog;
import filenet.vw.toolkit.admin.property.log.VWConfigLogPropertyDialog;
import filenet.vw.toolkit.admin.property.log.VWConfigNewEventLogDialog;
import filenet.vw.toolkit.admin.property.queue.VWConfigNewQueueDialog;
import filenet.vw.toolkit.admin.property.queue.VWConfigQueuePropertyDialog;
import filenet.vw.toolkit.admin.property.region.VWConfigRegionPropertyDialog;
import filenet.vw.toolkit.admin.property.region.VWCreateXliffDialog;
import filenet.vw.toolkit.admin.property.roster.VWConfigNewRosterDialog;
import filenet.vw.toolkit.admin.property.roster.VWConfigRosterPropertyDialog;
import filenet.vw.toolkit.admin.property.service.VWConfigVWServicePropertyDialog;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.ws.VWUDDIPublishDialog;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRPublishDialog;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class VWConfigPerformer {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILED = -1;
    public static final int STATUS_CANCELED = 1;
    private static final int OPTION_YES_NO = 1;
    private static final int OPTION_COMMIT_DISCARD = 2;
    private static final int OPTION_COMMIT_DISCARD_CANCEL = 3;
    private static final int DEFAULT_OPTION_NO = 1;
    private static final int DEFAULT_OPTION_COMMIT = 0;
    private static final Object[] OptionsYesNo = new Object[]{VWResource.Yes, VWResource.No};
    private static final Object[] OptionsYesNoCancel = new Object[]{VWResource.Yes, VWResource.No, VWResource.Cancel};
    private static final Object[] OptionsCommitDiscard = new Object[]{VWResource.Commit, VWResource.DiscardChanges};
    private static final Object[] OptionsCommitDiscardCancel = new Object[]{VWResource.Commit, VWResource.DiscardChanges, VWResource.Cancel};
    private VWSessionInfo m_sessionInfo = null;
    private Container m_mainContainer = null;
    private Frame m_parentFrame = null;
    private String m_title = null;
    private VWCreateXliffDialog m_createXliffDialog = null;
    private FileDialog m_openFileDialog = null;
    private VWWSRRPublishDialog m_WSRRPublishDialog = null;

    public VWConfigPerformer(VWSessionInfo sessionInfo) {
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_mainContainer = sessionInfo.getParentContainer();
            this.m_parentFrame = sessionInfo.getParentFrame();
            this.m_title = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWConfigPerformer(VWSessionInfo sessionInfo, String title) {
        this.m_sessionInfo = sessionInfo;
        this.m_mainContainer = sessionInfo.getParentContainer();
        this.m_parentFrame = sessionInfo.getParentFrame();
        this.m_title = title;
    }

    public void releaseResources() {
        this.m_sessionInfo = null;
        this.m_mainContainer = null;
        this.m_parentFrame = null;
        this.m_title = null;
        this.m_createXliffDialog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performLogon(VWConfigBaseNode focus) {
        boolean bLogon = false;
        try {
            try {
                if (focus.getType() == 19) {
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                    VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
                    VWSessionInfo sessionInfo = new VWSessionInfo(this.m_sessionInfo);
                    sessionInfo.setProperty("hostName", rNode.m_hostName);
                    sessionInfo.setProperty("routerNames", rNode.getRouterName());
                    sessionInfo.setProperty("routerPorts", Integer.toString(rNode.getRouterPort()));
                    if (sessionInfo.verifyLogonWithoutSessionManagement(VWResource.s_pwConfigurationGroup)) {
                        try {
                            rNode.logon(sessionInfo);
                            bLogon = true;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            rNode.setSessionInfo(null);
                            rNode.m_admin = null;
                            this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                            bLogon = false;
                        }
                    }
                }
                Object var7_7 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var7_8 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return bLogon;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bLogon;
    }

    public int confirmOptionDialog(String msgString, int option, int defaultOpt) {
        int retStatus;
        boolean bParentActive = true;
        Container parentComp = this.m_mainContainer;
        if (this.m_mainContainer instanceof JApplet && this.m_mainContainer != null && !((JApplet)this.m_mainContainer).isActive()) {
            parentComp = null;
            bParentActive = false;
        }
        switch (option) {
            case 3: {
                if (bParentActive) {
                    retStatus = JOptionPane.showOptionDialog(parentComp, msgString, this.m_title, -1, 3, null, OptionsCommitDiscardCancel, OptionsCommitDiscardCancel[0]);
                    break;
                }
                retStatus = JOptionPane.showOptionDialog(parentComp, msgString, this.m_title, -1, 3, null, OptionsCommitDiscard, OptionsCommitDiscard[0]);
                break;
            }
            case 2: {
                retStatus = JOptionPane.showOptionDialog(parentComp, msgString, this.m_title, -1, 3, null, OptionsCommitDiscard, OptionsCommitDiscard[0]);
                break;
            }
            default: {
                retStatus = JOptionPane.showOptionDialog(parentComp, msgString, this.m_title, -1, 3, null, OptionsYesNo, OptionsYesNo[defaultOpt]);
            }
        }
        return retStatus;
    }

    public void messageOptionDialog(Exception ex, String titleString, int option) {
        String message;
        Container parentComp = this.m_mainContainer;
        if (this.m_mainContainer != null && this.m_mainContainer instanceof JApplet && !((JApplet)this.m_mainContainer).isActive()) {
            parentComp = null;
        }
        if ((message = ex.getLocalizedMessage()) == null || message.length() == 0) {
            message = ex.getMessage();
        }
        if (message == null || message.length() == 0) {
            message = VWResource.Unknown;
        }
        String title = titleString;
        switch (option) {
            case 0: {
                if (title != null) break;
                title = VWResource.ErrorMessage;
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: {
                if (title != null) break;
                title = this.m_title;
                break;
            }
            default: {
                if (title == null) {
                    title = this.m_title;
                }
                option = -1;
            }
        }
        JOptionPane.showMessageDialog(parentComp, message, title, option);
    }

    public boolean performLogoff(VWConfigBaseNode focus, boolean bEnableCancel) {
        if (focus == null) {
            return false;
        }
        VWConfigRegionNode rNode = null;
        switch (focus.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                rNode = (VWConfigRegionNode)focus.findAncestorNode(19);
                break;
            }
            case 19: {
                rNode = (VWConfigRegionNode)focus;
            }
        }
        if (rNode == null) {
            return false;
        }
        if (rNode.getSessionInfo() != null) {
            if (!this.promptBeforeCommit(rNode, bEnableCancel)) {
                return false;
            }
            try {
                rNode.logoff();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                rNode.setSessionInfo(null);
                rNode.m_admin = null;
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                return false;
            }
        }
        return true;
    }

    public boolean promptBeforeCommit(VWConfigRegionNode rNode, boolean bEnableCancel) {
        if (rNode == null) {
            return false;
        }
        if (rNode.getSessionInfo() != null && rNode.isDirty()) {
            int nReturnVal = this.confirmOptionDialog(VWResource.ConfirmVWServiceRegionCommit.toString(rNode.getServiceName(), rNode.getRegionIDString()), bEnableCancel ? 3 : 2, 0);
            switch (nReturnVal) {
                case 0: {
                    if (this.performCommit(rNode)) break;
                    return false;
                }
                case 1: {
                    if (this.performDiscard(rNode, false, true) == 0) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean performCommit(VWConfigBaseNode focus) {
        boolean bSuccess = false;
        VWConfigCommittalDialog committalDialog = new VWConfigCommittalDialog(this.m_parentFrame, focus, this.m_title);
        committalDialog.setVisible(true);
        bSuccess = committalDialog.getStatus();
        committalDialog.releaseResources();
        return bSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performRegionDiscard(VWConfigRegionNode rNode, boolean bConfirm, boolean bRefetch) {
        boolean bSuccess = false;
        int ret = 0;
        try {
            try {
                if (bConfirm) {
                    ret = this.confirmOptionDialog(VWResource.ConfirmDiscard.toString(rNode.getServiceName(), rNode.getRegionIDString()), 1, 1);
                }
                if (ret == 0) {
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                    bSuccess = bRefetch ? rNode.discardChanges(2) : rNode.discardChanges(1);
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                }
                bSuccess = true;
            }
            catch (Exception ex) {
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                VWDebug.logException(ex);
                Object var8_7 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return bSuccess;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bSuccess;
    }

    public boolean performVWServiceDiscard(VWConfigVWServiceNode sNode, boolean bConfirm, boolean bRefetch) {
        VWConfigRegionNode rNode;
        boolean bSuccess = false;
        int childCount = sNode.getChildCount();
        for (int i = 0; i < childCount && (bSuccess = this.performRegionDiscard(rNode = (VWConfigRegionNode)sNode.getChildAt(i), bConfirm, bRefetch)); ++i) {
        }
        return bSuccess;
    }

    public int performDiscard(VWConfigBaseNode focus, boolean bConfirm, boolean bRefetch) {
        int status = 0;
        int nodeType = focus.getType();
        VWConfigRegionNode rNode = null;
        try {
            block1 : switch (nodeType) {
                case 17: {
                    int retStatus = bConfirm ? this.confirmOptionDialog(VWResource.ConfirmGlobalDiscard, 1, 1) : 0;
                    if (retStatus == 0) {
                        int childCount = focus.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)focus.getChildAt(i);
                            if (this.performVWServiceDiscard(sNode, false, bRefetch)) continue;
                            status = -1;
                            break block1;
                        }
                        break;
                    }
                    status = 1;
                    break;
                }
                case 18: {
                    int retStatus = bConfirm ? this.confirmOptionDialog(VWResource.ConfirmVWServiceDiscard.toString(focus.getName()), 1, 1) : 0;
                    if (retStatus == 0) {
                        int childCount = focus.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            rNode = (VWConfigRegionNode)focus.getChildAt(i);
                            if (this.performRegionDiscard(rNode, false, bRefetch)) continue;
                            status = -1;
                            break block1;
                        }
                        break;
                    }
                    status = 1;
                    break;
                }
                default: {
                    rNode = focus instanceof VWConfigRegionNode ? (VWConfigRegionNode)focus : (VWConfigRegionNode)focus.findAncestorNode(19);
                    if (rNode == null) {
                        status = -1;
                        break;
                    }
                    int retStatus = bConfirm ? this.confirmOptionDialog(VWResource.ConfirmDiscard.toString(rNode.getServiceName(), rNode.getRegionIDString()), 1, 1) : 0;
                    if (retStatus == 0) {
                        if (!this.performRegionDiscard(rNode, false, bRefetch)) {
                            status = -1;
                        }
                        break;
                    }
                    status = 1;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            status = -1;
        }
        return status;
    }

    public void performVWServiceProperties(VWConfigBaseNode focus) {
        if (focus.getType() == 18) {
            VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)focus;
            VWConfigVWServicePropertyDialog servicePropertyDialog = new VWConfigVWServicePropertyDialog(this.m_parentFrame, sNode);
            servicePropertyDialog.setVisible(true);
            servicePropertyDialog.releaseResources();
        }
    }

    public void performHelp(VWConfigBaseNode focus) {
        if (focus == null) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc012.htm");
            return;
        }
        switch (focus.getType()) {
            case 17: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc069.htm");
                break;
            }
            case 0: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc012.htm");
                break;
            }
            case 18: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc075.htm");
                break;
            }
            case 19: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc067.htm");
                break;
            }
            case 24: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc056.htm");
                break;
            }
            case 20: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc077.htm");
                break;
            }
            case 21: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc074.htm");
                break;
            }
            case 5: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc051.htm");
                break;
            }
            case 1: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc066.htm");
                break;
            }
            case 2: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc066.htm");
                break;
            }
            case 22: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc070.htm");
                break;
            }
            case 3: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc071.htm");
                break;
            }
            case 23: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc057.htm");
                break;
            }
            case 4: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc061.htm");
                break;
            }
            case 25: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc053.htm");
                break;
            }
            case 6: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc054.htm");
                break;
            }
            default: {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc012.htm");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performRemoveWorkflowDataBase(VWConfigBaseNode focus) {
        boolean bSuccess = false;
        int ret = JOptionPane.showOptionDialog(this.m_mainContainer, VWResource.ConfirmRemoveDatabase.toString(VWResource.CautionRemoveAllIRs, focus.getName()), this.m_title, -1, 2, null, OptionsYesNo, OptionsYesNo[1]);
        if (ret != 0) return bSuccess;
        try {
            try {
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)focus;
                VWConfigRegionNode rNode = null;
                int childCount = serviceNode.getChildCount();
                VWConfigRegionNode regionNode = null;
                for (int i = 0; i < childCount; ++i) {
                    rNode = (VWConfigRegionNode)serviceNode.getChildAt(i);
                    if (rNode.m_admin == null) continue;
                    if (regionNode == null) {
                        regionNode = rNode;
                    } else {
                        rNode.logoff();
                    }
                    if (!rNode.isDirty()) continue;
                    rNode.discardChanges(1);
                }
                regionNode.m_admin.removeWorkflowDatabase();
                regionNode.logoff();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                bSuccess = true;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                Object var10_11 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return bSuccess;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performRemoveAllRegions(VWConfigBaseNode focus) {
        boolean bSuccess = false;
        int ret = JOptionPane.showOptionDialog(this.m_mainContainer, VWResource.ConfirmRemoveAllRegions.toString(VWResource.CautionRemoveAllIRs, focus.getName()), this.m_title, -1, 2, null, OptionsYesNo, OptionsYesNo[1]);
        if (ret != 0) return bSuccess;
        try {
            try {
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)focus;
                VWConfigRegionNode rNode = null;
                int childCount = serviceNode.getChildCount();
                VWConfigRegionNode regionNode = null;
                for (int i = 0; i < childCount; ++i) {
                    rNode = (VWConfigRegionNode)serviceNode.getChildAt(i);
                    if (rNode.getSessionInfo() == null) continue;
                    if (regionNode == null) {
                        regionNode = rNode;
                    } else {
                        rNode.logoff();
                    }
                    if (!rNode.isDirty()) continue;
                    rNode.discardChanges(1);
                }
                regionNode.m_admin.removeAllRegions();
                regionNode.logoff();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                bSuccess = true;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                Object var10_11 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return bSuccess;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performInitRegion(VWConfigBaseNode focus) {
        boolean bSuccess = false;
        VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
        int ret = this.confirmOptionDialog(VWResource.ConfirmInitIR.toString(rNode.getServiceName(), rNode.getRegionIDString()), 1, 1);
        if (ret != 0) return bSuccess;
        try {
            try {
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                rNode.initRegion();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                bSuccess = true;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                Object var7_6 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return bSuccess;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performRemoveRegion(VWConfigBaseNode focus) {
        boolean bSuccess = false;
        VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
        int ret = this.confirmOptionDialog(VWResource.ConfirmRemoveIR.toString(rNode.getServiceName(), rNode.getRegionIDString()), 1, 1);
        if (ret != 0) return bSuccess;
        try {
            try {
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                if (rNode.isDirty()) {
                    rNode.discardChanges(1);
                }
                rNode.m_admin.removeRegion();
                rNode.logoff();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                bSuccess = true;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                Object var7_6 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return bSuccess;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
        return bSuccess;
    }

    public void performNewComponent(VWConfigBaseNode focus) {
        VWConfigFolderNode folder = (VWConfigFolderNode)focus;
        VWNewComponentDialog dlg = new VWNewComponentDialog(this.m_parentFrame, (VWConfigRegionNode)folder.getParent(), ((VWConfigRegionNode)folder.getParent()).getSystemConfiguration());
        dlg.setVisible(true);
        VWConfigQueueNode newQueue = dlg.getQueueNode();
        if (newQueue != null) {
            folder.add(newQueue, 1);
            newQueue.setDirty(true);
            newQueue.fireStatusEvent(9);
        }
        dlg.releaseResources();
    }

    public void performComponentRegistration(VWConfigBaseNode focus) {
        VWConfigFolderNode folder = (VWConfigFolderNode)focus;
        VWComponentRegistrationDialog dlg = new VWComponentRegistrationDialog(this.m_parentFrame, ((VWConfigRegionNode)folder.getParent()).getSystemConfiguration());
        dlg.setVisible(true);
        if (dlg.getStatus() == 0 && dlg.isModified()) {
            focus.setDirty(true);
            focus.fireStatusEvent(4);
        }
        dlg.releaseResources();
    }

    public void performNewQueue(VWConfigBaseNode focus) {
        VWConfigFolderNode qFolder = (VWConfigFolderNode)focus;
        int qType = qFolder.getType() == 20 ? 1 : 2;
        VWConfigNewQueueDialog qDialog = new VWConfigNewQueueDialog(this.m_parentFrame, qType, (VWConfigBaseNode)qFolder.getParent());
        qDialog.setVisible(true);
        VWConfigQueueNode newQueue = qDialog.getQueueNode();
        if (newQueue != null) {
            qFolder.add(newQueue, 1);
            newQueue.setDirty(true);
            newQueue.fireStatusEvent(9);
        }
        qDialog.releaseResources();
    }

    public void performNewRoster(VWConfigBaseNode focus) {
        VWConfigFolderNode rosterFolder = (VWConfigFolderNode)focus;
        VWConfigNewRosterDialog rosterDialog = new VWConfigNewRosterDialog(this.m_parentFrame, (VWConfigBaseNode)rosterFolder.getParent());
        rosterDialog.setVisible(true);
        VWConfigRosterNode newRoster = rosterDialog.getRosterNode();
        if (newRoster != null) {
            rosterFolder.add(newRoster, 1);
            newRoster.setDirty(true);
            newRoster.fireStatusEvent(10);
        }
        rosterDialog.releaseResources();
    }

    public void performNewEventLog(VWConfigBaseNode focus) {
        VWConfigFolderNode logFolder = (VWConfigFolderNode)focus;
        VWConfigNewEventLogDialog logDialog = new VWConfigNewEventLogDialog(this.m_parentFrame, (VWConfigBaseNode)logFolder.getParent());
        logDialog.setVisible(true);
        VWConfigEventLogNode newLog = logDialog.getLogNode();
        if (newLog != null) {
            logFolder.add(newLog, 1);
            newLog.setDirty(true);
            newLog.fireStatusEvent(11);
        }
        logDialog.releaseResources();
    }

    public void performNewAppSpace(VWConfigBaseNode focus) {
        VWConfigFolderNode appSpaceFolder = (VWConfigFolderNode)focus;
        VWNewAppSpaceDialog appSpaceDialog = new VWNewAppSpaceDialog(this.m_parentFrame, (VWConfigBaseNode)appSpaceFolder.getParent());
        appSpaceDialog.setVisible(true);
        VWConfigAppSpaceNode newAppSpace = appSpaceDialog.getNewNode();
        if (newAppSpace != null) {
            appSpaceFolder.add(newAppSpace, 1);
            newAppSpace.setDirty(true);
            newAppSpace.fireStatusEvent(13);
        }
        appSpaceDialog.releaseResources();
    }

    public void performRegionProperties(VWConfigBaseNode focus) {
        VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
        VWConfigRegionPropertyDialog regionPropertyDialog = new VWConfigRegionPropertyDialog(this.m_parentFrame, rNode);
        regionPropertyDialog.setVisible(true);
        if (regionPropertyDialog.isModified()) {
            focus.setDirty(true);
            focus.fireStatusEvent(4);
        }
        regionPropertyDialog.releaseResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performComponentQueueProperty(VWConfigBaseNode focus) {
        try {
            try {
                VWConfigQueueNode qNode = (VWConfigQueueNode)focus;
                if (qNode == null) {
                    throw new VWException("vw.toolkit.admin.VWConfigPerformer.nullQueueNode", "The queue node is null.");
                }
                VWSystemConfiguration vwSysConfig = this.getSystemConfiguration(qNode);
                VWQueueDefinition queueDef = qNode.getDefinition();
                qNode.countWorkItemsAffected();
                int workItems = qNode.getWorkItemsAffected();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                VWComponentPropertyDialog componentDialog = new VWComponentPropertyDialog(this.m_parentFrame, qNode.getSessionInfo(), queueDef, vwSysConfig, workItems);
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                componentDialog.setVisible(true);
                if (componentDialog.getStatus() == 0 && componentDialog.isModified()) {
                    qNode.setDefinition(queueDef);
                    focus.setDirty(true);
                    focus.fireStatusEvent(7);
                }
                componentDialog.releaseResources();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                this.messageOptionDialog(ex, VWResource.ErrorMessage, 0);
                Object var8_9 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performQueueProperty(VWConfigBaseNode focus) {
        VWConfigQueuePropertyDialog queueDialog;
        block8: {
            try {
                try {
                    VWSystemConfiguration sysConfig;
                    VWApplicationSpaceDefinition[] asDefs;
                    VWConfigQueueNode qNode = (VWConfigQueueNode)focus;
                    VWSystemConfiguration vwSysConfig = this.getSystemConfiguration(qNode);
                    VWQueueDefinition clonedQueueDef = qNode.getDefinition();
                    Hashtable mappingTable = qNode.getWorkBasketMap(clonedQueueDef);
                    qNode.countWorkItemsAffected();
                    int workItems = qNode.getWorkItemsAffected();
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                    queueDialog = new VWConfigQueuePropertyDialog(this.m_parentFrame, qNode.getSessionInfo(), vwSysConfig, clonedQueueDef, workItems);
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                    queueDialog.setVisible(true);
                    if (queueDialog.getStatus() != 0 || !queueDialog.isModified()) break block8;
                    qNode.setDefinition(clonedQueueDef);
                    focus.setDirty(true);
                    focus.fireStatusEvent(7);
                    if (mappingTable != null && (asDefs = (sysConfig = this.getSystemConfiguration(qNode)).getApplicationSpaceDefinitions()) != null) {
                        for (int i = 0; i < asDefs.length; ++i) {
                            if (asDefs[i] == null) continue;
                            boolean bUpdated = false;
                            VWRoleDefinition[] roleDefs = asDefs[i].getRoleDefinitions();
                            if (roleDefs == null) continue;
                            for (int j = 0; j < roleDefs.length; ++j) {
                                VWWorkBasketDefinition[] wbDefs;
                                if (roleDefs[j] == null || (wbDefs = roleDefs[j].getWorkBasketDefinitions()) == null) continue;
                                for (int k = 0; k < wbDefs.length; ++k) {
                                    if (wbDefs[k] == null || !mappingTable.containsKey(wbDefs[k])) continue;
                                    wbDefs[k] = (VWWorkBasketDefinition)mappingTable.get(wbDefs[k]);
                                    bUpdated = true;
                                }
                                if (!bUpdated) continue;
                                roleDefs[j].setWorkBasketDefinitions(wbDefs);
                            }
                            if (!bUpdated) continue;
                            this.notifyOfChangedAppSpace(qNode, asDefs[i].getName());
                        }
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var17_18 = null;
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
        }
        queueDialog.releaseResources();
        Object var17_17 = null;
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performRosterProperty(VWConfigBaseNode focus) {
        try {
            try {
                VWConfigRosterNode rNode = (VWConfigRosterNode)focus;
                VWSystemConfiguration vwSysConfig = this.getSystemConfiguration(rNode);
                VWRosterDefinition rosterDef = rNode.getDefinition();
                rNode.countWorkItemsAffected();
                int workItems = rNode.getWorkItemsAffected();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                VWConfigRosterPropertyDialog rosterDialog = new VWConfigRosterPropertyDialog(this.m_parentFrame, rNode.getSessionInfo(), vwSysConfig, rosterDef, workItems);
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                rosterDialog.setVisible(true);
                if (rosterDialog.getStatus() == 0 && rosterDialog.isModified()) {
                    rNode.setDefinition(rosterDef);
                    focus.setDirty(true);
                    focus.fireStatusEvent(8);
                }
                rosterDialog.releaseResources();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var8_9 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performEventLogProperty(VWConfigBaseNode focus) {
        try {
            block4: {
                try {
                    VWConfigEventLogNode elNode = (VWConfigEventLogNode)focus;
                    VWSystemConfiguration vwSysConfig = this.getSystemConfiguration(elNode);
                    VWLogDefinition logDef = elNode.getDefinition();
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                    VWConfigLogPropertyDialog logDialog = new VWConfigLogPropertyDialog(this.m_parentFrame, elNode.getSession(), vwSysConfig, logDef);
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                    logDialog.setVisible(true);
                    if (logDialog.getStatus() != 0 || !logDialog.isModified()) break block4;
                    elNode.setDefinition(logDef);
                    focus.setDirty(true);
                    focus.fireStatusEvent(6);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var7_8 = null;
                    this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            Object var7_7 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performAppSpaceProperty(VWConfigBaseNode focus) {
        try {
            try {
                VWConfigAppSpaceNode appSpaceNode = (VWConfigAppSpaceNode)focus;
                VWApplicationSpaceDefinition appSpaceDef = appSpaceNode.getDefinition();
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
                VWAppSpacePropertyDialog appSpaceDlg = new VWAppSpacePropertyDialog(appSpaceNode.getSessionInfo(), appSpaceNode.getSystemConfiguration(), appSpaceDef);
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                appSpaceDlg.setVisible(true);
                if (appSpaceDlg.getExitStatus() == 0 && appSpaceDlg.isModified()) {
                    appSpaceNode.setDefinition(appSpaceDef);
                    focus.setDirty(true);
                    focus.fireStatusEvent(14);
                    String[] modifiedQueueNames = appSpaceDlg.getModifiedQueueNames();
                    if (modifiedQueueNames != null) {
                        for (int nIndex = 0; nIndex < modifiedQueueNames.length; ++nIndex) {
                            this.notifyOfChangedQueue(focus, modifiedQueueNames[nIndex]);
                        }
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var8_9 = null;
                this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void performExportToCrossWorlds(VWConfigBaseNode focus) {
    }

    public void performExport(VWConfigBaseNode focus) {
        try {
            if (focus.getType() == 19) {
                VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
                if (!rNode.isRegionInitialized()) {
                    String msg = VWResource.RegionHasNotBeenInitialized.toString(rNode.getRegionIDString(), rNode.getServiceName());
                    JOptionPane.showMessageDialog(this.m_parentFrame, msg, VWResource.Error, 0);
                    return;
                }
                if (rNode.isDirty()) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.ExportWarning.toString(rNode.getRegionIDString()), VWResource.Error, 0);
                    return;
                }
                VWExportWizardDialog exportDialog = new VWExportWizardDialog(this.m_parentFrame, rNode);
                exportDialog.setVisible(true);
                exportDialog.releaseResources();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            VWDebug.logException(ex);
        }
    }

    public void performImport(VWConfigBaseNode focus) {
        try {
            if (focus.getType() != 19) {
                return;
            }
            VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
            if (!rNode.isRegionInitialized()) {
                String msg = VWResource.RegionHasNotBeenInitialized.toString(rNode.getRegionIDString(), rNode.getServiceName());
                JOptionPane.showMessageDialog(this.m_parentFrame, msg, VWResource.Error, 0);
                return;
            }
            if (rNode.isDirty()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.ImportWarning.toString(rNode.getRegionIDString()), VWResource.Error, 0);
                return;
            }
            VWImportDialog ImportDialog = new VWImportDialog(this.m_parentFrame, rNode);
            ImportDialog.setVisible(true);
            ImportDialog.releaseResources();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            VWDebug.logException(ex);
        }
    }

    public void performPublishToUDDI(VWConfigBaseNode focus) {
        try {
            if (focus.getType() != 19) {
                return;
            }
            VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
            if (rNode.isDirty()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.UDDIWarning.toString(rNode.getRegionIDString()), VWResource.Error, 0);
                return;
            }
            VWUDDIPublishDialog uddiPublishDialog = new VWUDDIPublishDialog(this.m_parentFrame, focus.getSession());
            uddiPublishDialog.setVisible(true);
            rNode.refresh(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            VWDebug.logException(ex);
        }
    }

    public void performPublishToWSRR(VWConfigBaseNode focus) {
        try {
            if (focus.getType() != 19) {
                return;
            }
            VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
            if (rNode.isDirty()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.WSRRWarning.toString(rNode.getRegionIDString()), VWResource.Error, 0);
                return;
            }
            VWSession session = focus.getSession();
            if (this.m_WSRRPublishDialog == null) {
                this.m_WSRRPublishDialog = new VWWSRRPublishDialog(this.m_parentFrame, focus.getSession());
            } else if (this.m_WSRRPublishDialog.getSession() != session) {
                this.m_WSRRPublishDialog = new VWWSRRPublishDialog(this.m_parentFrame, focus.getSession());
            } else {
                this.m_WSRRPublishDialog.initializePanelData();
            }
            this.m_WSRRPublishDialog.setVisible(true);
            rNode.refresh(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            VWDebug.logException(ex);
        }
    }

    public void performCreateXliffFile(VWConfigBaseNode focus) {
        try {
            if (focus.getType() != 19) {
                return;
            }
            VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
            if (rNode.isDirty()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CreateXLIFFWarning.toString(rNode.getRegionIDString()), VWResource.Error, 0);
                return;
            }
            if (this.m_createXliffDialog == null) {
                this.m_createXliffDialog = new VWCreateXliffDialog(this.m_parentFrame);
            }
            this.m_createXliffDialog.initialize(rNode);
            this.m_createXliffDialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            VWDebug.logException(ex);
        }
    }

    public void performVerifyXliffFile(VWConfigBaseNode focus) {
        try {
            if (focus.getType() != 19) {
                return;
            }
            if (this.m_openFileDialog == null) {
                this.m_openFileDialog = new FileDialog(this.m_parentFrame, VWResource.OpenDialogTitle, 0);
                this.m_openFileDialog.setDirectory(System.getProperty("user.dir") + File.separator);
            }
            this.m_openFileDialog.setVisible(true);
            String fileName = this.m_openFileDialog.getFile();
            if (fileName != null) {
                String[] warnings;
                VWConfigRegionNode regionNode = (VWConfigRegionNode)focus;
                VWXLIFFHandler xliffHandler = new VWXLIFFHandler(regionNode.getRegionID());
                String directory = this.m_openFileDialog.getDirectory();
                if (directory != null && directory.length() > 0) {
                    fileName = directory + fileName;
                }
                if ((warnings = xliffHandler.verifyXliffFile(fileName)) != null) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, warnings, VWResource.XLIFFVerificationWarnings, 3);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.XLIFFVerificationSuccessful, 2);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            VWDebug.logException(ex);
        }
    }

    public VWConfigBaseNode performDeleteItem(VWConfigBaseNode focusNode) {
        if (focusNode == null) {
            return focusNode;
        }
        VWConfigRegionNode regionNode = (VWConfigRegionNode)focusNode.findAncestorNode(19);
        try {
            switch (focusNode.getType()) {
                case 6: {
                    if (focusNode instanceof VWConfigAppSpaceNode && regionNode != null) {
                        VWApplicationSpaceDefinition appSpaceDef = ((VWConfigAppSpaceNode)focusNode).getDefinition();
                        regionNode.getSystemConfiguration().deleteApplicationSpaceDefinition(appSpaceDef.getName());
                    }
                    break;
                }
                case 1: 
                case 5: {
                    if (focusNode instanceof VWConfigQueueNode && regionNode != null) {
                        VWQueueDefinition queueDef = ((VWConfigQueueNode)focusNode).getDefinition();
                        regionNode.getSystemConfiguration().deleteQueueDefinition(queueDef.getName());
                    }
                    break;
                }
                case 4: {
                    if (focusNode instanceof VWConfigEventLogNode && regionNode != null) {
                        VWLogDefinition logDef = ((VWConfigEventLogNode)focusNode).getDefinition();
                        regionNode.getSystemConfiguration().deleteLogDefinition(logDef.getName());
                    }
                    break;
                }
                case 3: {
                    if (focusNode instanceof VWConfigRosterNode && regionNode != null) {
                        VWRosterDefinition rosterDef = ((VWConfigRosterNode)focusNode).getDefinition();
                        regionNode.getSystemConfiguration().deleteRosterDefinition(rosterDef.getName());
                    }
                    break;
                }
                default: {
                    throw new VWException("vw.toolkit.admin.CannotDeleteObject", "This object cannot be deleted.");
                }
            }
        }
        catch (VWException ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.Error, 0);
            return focusNode;
        }
        focusNode.fireStatusEvent(15);
        VWConfigBaseNode parentNode = (VWConfigBaseNode)focusNode.getParent();
        focusNode.removeFromParent();
        return parentNode;
    }

    public void notifyOfChangedQueue(VWConfigBaseNode focus, String queueName) {
        VWConfigQueueNode qNode;
        boolean bFound = false;
        VWConfigRegionNode rNode = (VWConfigRegionNode)focus.findAncestorNode(19);
        Enumeration<TreeNode> nodeEnum = rNode.m_queueFolder.children();
        while (nodeEnum.hasMoreElements()) {
            qNode = (VWConfigQueueNode)nodeEnum.nextElement();
            if (VWStringUtils.compare(queueName, qNode.getName()) != 0) continue;
            qNode.setDirty(true);
            qNode.fireStatusEvent(7);
            bFound = true;
            break;
        }
        if (!bFound) {
            nodeEnum = rNode.m_userQueueFolder.children();
            while (nodeEnum.hasMoreElements()) {
                qNode = (VWConfigQueueNode)nodeEnum.nextElement();
                if (VWStringUtils.compare(queueName, qNode.getName()) != 0) continue;
                qNode.setDirty(true);
                qNode.fireStatusEvent(7);
                break;
            }
        }
    }

    public void notifyOfChangedAppSpace(VWConfigBaseNode focus, String appSpaceName) {
        VWConfigRegionNode rNode = (VWConfigRegionNode)focus.findAncestorNode(19);
        Enumeration<TreeNode> nodeEnum = rNode.m_appSpaceFolder.children();
        while (nodeEnum.hasMoreElements()) {
            VWConfigAppSpaceNode asNode = (VWConfigAppSpaceNode)nodeEnum.nextElement();
            if (VWStringUtils.compare(appSpaceName, asNode.getName()) != 0) continue;
            asNode.setDirty(true);
            asNode.fireStatusEvent(14);
            break;
        }
    }

    public void notifyOfAddedStepProcessor(VWConfigBaseNode focus) {
        VWConfigRegionNode rNode = (VWConfigRegionNode)focus.findAncestorNode(19);
        if (rNode != null) {
            rNode.setDirty(true);
            rNode.fireStatusEvent(4);
        }
    }

    private VWSystemConfiguration getSystemConfiguration(VWConfigBaseNode baseNode) throws VWException {
        VWSystemConfiguration vwSysConfig = null;
        while (baseNode != null) {
            if (baseNode instanceof VWConfigRegionNode) {
                vwSysConfig = ((VWConfigRegionNode)baseNode).getSystemConfiguration();
                break;
            }
            baseNode = (VWConfigBaseNode)baseNode.getParent();
        }
        if (vwSysConfig == null) {
            throw new VWException("vw.toolkit.admin.VWConfigPerformer.nullSystemConfiguration", "Unable to retrieve system configuration.");
        }
        return vwSysConfig;
    }
}

